
#property copyright ""
#property link      ""

#property indicator_separate_window
#property indicator_minimum -35.0
#property indicator_maximum 35.0
#property indicator_buffers 4
#property indicator_color1 Lime
#property indicator_color2 Lime
#property indicator_color3 Red
#property indicator_color4 Blue
#property indicator_level2 12.0
#property indicator_level3 -12.0

extern bool   alertsOn        = true;
extern bool   alertsOnCurrent = true;
extern bool   alertsMessage   = true;
extern bool   alertsSound     = false;
extern bool   alertsEmail     = false;

double AboveBuff[];
double ShortBuff[];
double LongBuffe[];
double BelowBuff[];

// ---
int init() {
   SetIndexBuffer(0, AboveBuff); SetIndexStyle(0, DRAW_HISTOGRAM, EMPTY, 2);                          // Lime Above 0
   SetIndexBuffer(1, BelowBuff); SetIndexStyle(1, DRAW_HISTOGRAM, EMPTY, 2);                          // Lime Below 0
   SetIndexBuffer(2, ShortBuff); SetIndexStyle(2, DRAW_ARROW, EMPTY, 2);       SetIndexArrow(2, 108); // Red
   SetIndexBuffer(3, LongBuffe); SetIndexStyle(3, DRAW_ARROW, EMPTY, 2);       SetIndexArrow(3, 108); // Blue
   

   SetIndexLabel(0, "Above");
   SetIndexLabel(1, "Below");   
   SetIndexLabel(2, NULL);  
   SetIndexLabel(3, NULL);  
   
   SetLevelStyle(STYLE_DOT, 0, SteelBlue);

   IndicatorShortName(" Similar to Fx MTN ");
   return (0);
}
	 	    			  		  		   		 	 	 	 	 		 						 	   				  	   	 		 			  			  	     		  	 			   	 	     			 	 		 		     			 	 	  		 	  		   			 			    	
// ---
void deinit() {
   Comment("");
}
		    			 	 			 	 	  	  		  	   	 				 			     		 	 	 	 		 	 	 	 	 		 		 		  	    					   		  	    	 					 	  	    	 			 	 	 		 	 	  	 	   	  	 	
// ---
void start()
{
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-1);
      
      for (int i = limit; i >=0; i--) 
      {
         double Temp = 0.0; for (int j = i; j < i + 5; j++) Temp += (High[j] + Low[j]) / 2.0;
         double Main = Temp / 5.0;
                Temp = 0.0;  for (j = i; j < i + 5; j++) Temp += High[j] - Low[j];
         double Minr = 0.2 * (Temp / 5.0);
         
            if (Minr!=0)
            {
               AboveBuff[i] = 3.0 * (High[i]  - Main) / Minr;
               BelowBuff[i] = 3.0 * (Low[i]   - Main) / Minr;
            }               
            ShortBuff[i] = EMPTY_VALUE;
            LongBuffe[i] = EMPTY_VALUE;
            if (AboveBuff[i] >  24.0) ShortBuff[i] =  25;
            if (BelowBuff[i] < -24.0) LongBuffe[i] = -25;
      }
   manageAlerts();
   return(0);
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1;
      if (ShortBuff[whichBar] != EMPTY_VALUE || LongBuffe[whichBar] != EMPTY_VALUE)
      {
         if (ShortBuff[whichBar] !=  EMPTY_VALUE) doAlert(whichBar,"down");
         if (LongBuffe[whichBar] !=  EMPTY_VALUE) doAlert(whichBar,"up");
      }
   }
}

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," SimilarFxMNT signal ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol()," SimilarFxMNT "),message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}

